import pandas as pd
import numpy as np

video_name = 'VID_084027'

models_first = ['m2', 'm3', 'm4', 'm8']
models_second = ['y5m', 'y5l', 'y5x']
models = models_first + models_second

data_version = 'aeresults'
energy_version = 'ene'

excel_path = './{}/{}_{}.xlsx'.format(data_version, video_name, energy_version)
df = pd.read_excel(excel_path)


data = []
for model in models:
    list2 = df[model].tolist()
    data += list2

min_val = 0 # np.min(data)
max_val = np.max(data)
diff = max_val - min_val



num_bins = 10

bins = np.linspace(min_val, max_val, num_bins + 1)

hist, bin_edges = np.histogram(data, bins=bins, density=True)

cdf = np.cumsum(hist * np.diff(bin_edges))

cdf_ranges = list(zip(bin_edges[:-1], bin_edges[1:], cdf))


print("CDF Points:")
for start, end, value in cdf_ranges:
    print(f"Accuracy Range: {start:.2f} to {end:.2f}, CDF: {value:.2f}")
